/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.tsd;

import com.ibm.hwmca.base.rsf.BaseRemoteSupportFacility;
import com.ibm.hwmca.base.tsd.TransIOCDSFilesBean;
import com.ibm.hwmca.base.tsd.TransSrvDataBean;
import com.ibm.hwmca.base.tsd.TransVRetainBean;
import com.ibm.hwmca.base.tsd.TransmitSvcDataUtils;
import com.ibm.hwmca.base.tsd.TsdCopyDataException;
import com.ibm.hwmca.base.tsd.TsdEnableControl;
import com.ibm.hwmca.base.tsd.TsdEntryData;
import com.ibm.hwmca.base.tsd.TsdEntryDataParser;
import com.ibm.hwmca.base.tsd.TsdErrorIds;
import com.ibm.hwmca.base.tsd.TsdMediaInUseException;
import com.ibm.hwmca.base.tsd.TsdMediaLabelException;
import com.ibm.hwmca.base.tsd.TsdMediaNotReadyException;
import com.ibm.hwmca.base.tsd.TsdMediaWriteProtectedException;
import com.ibm.hwmca.base.tsd.TsdNoSpaceException;
import com.ibm.hwmca.base.tsd.TsdRetrieveDataException;
import com.ibm.hwmca.base.tsd.TsdSendData;
import com.ibm.hwmca.base.tsd.TsdWriteDisk;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseTextBundle;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.MicrocodeLogAttributes;
import com.ibm.hwmca.fw.managed.User;
import com.ibm.hwmca.fw.mediasvc.MediaServices;
import com.ibm.hwmca.fw.msgpanel.CommonMsgInterface;
import com.ibm.hwmca.fw.rsf.RsfManager;
import com.ibm.hwmca.fw.task.HwmcaPanelTasklet;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import java.io.File;
import java.util.List;

public class TsdTasklet
extends HwmcaPanelTasklet
implements TsdErrorIds {
    private static final String TRACE_MASKT = "XTSD   T";
    private static final String TRACE_MASKF = "XTSD   F";
    private static final String TRACE_MASKD = "XTSD   D";
    private static FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(-44, "TsdTasklet");
    private static MicrocodeLogAttributes infoLog = MicrocodeLogAttributes.INFO_LOG;
    private static final String AUIML = "com.ibm.hwmca.base.tsd.res.TransSrvDataRes";
    private static final String utilClass = "com.ibm.hwmca.base.tsd.TransmitSvcDataUtils";
    private static final String PANEL = "TransSrvDataPanel";
    private static final String VRETAIN_PANEL = "VRetainFilesPanel";
    private static final String IOCDS_PANEL = "IOCDSFilePanel";
    private static final String VIRTUAL_RETAIN_DIR = "virtualretain";
    private static final String IOCDS_FILE_LOCATION_PATTERN = "iqzk????.dat";
    private static final String IOCDS_FILE_PATTERN = "iqzk*";
    private static final String iocdsFilename = "iqysiocd.zip";
    private TransSrvDataBean bean;
    private TsdEntryData[] tsdEntryData = null;
    private List tsdEntryList;
    private String[] vretainList = null;
    private String[] iocdsList = null;
    private String vretainFilePath = null;
    private String vretainFilename = null;
    private String iocdsFilePath = null;
    private boolean disketteItemChanged = false;
    private int newDeviceIdentifier = 0;
    private LocalizableText newDeviceText = new LocalizableText("");
    private boolean sendRetainOk;
    private static final String TSD_BUSY_TITLE = "tsd.busy.title";
    private static final String TSD_TASK_TITLE = "tsd.task.title";
    private static final String TSD_BUSY_QUERY_TEXT = "tsd.busy_query.text";
    private static final String TSD_BUSY_SEND_TEXT = "tsd.busy_send.text";
    private static final String TSD_BUSY_COPY_TEXT = "tsd.busy_copy.text";
    public static final String BUNDLE_NAME = "com/ibm/hwmca/base/tsd/res/TransSrvDataStuffRes";

    public TsdTasklet() {
        Trace.trace(TRACE_MASKT, "<-> TsdTasklet()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean initData() {
        block24: {
            block21: {
                block22: {
                    block25: {
                        Trace.trace("XTSD   T", "--> initData()");
                        result = true;
                        busyDialogVisible = false;
                        this.showBusyDialog(new LocalizableText(BaseTextBundle.getBundleName(), "tsd.busy.title"), new LocalizableText(BaseTextBundle.getBundleName(), "tsd.busy_query.text"));
                        busyDialogVisible = true;
                        this.tsdEntryList = TsdEntryDataParser.parseTsdData();
                        this.tsdEntryData = new TsdEntryData[this.tsdEntryList.size()];
                        this.tsdEntryData = this.tsdEntryList.toArray(this.tsdEntryData);
                        busyDialogVisible = false;
                        this.destroyBusyDialog();
                        if (this.tsdEntryData == null || this.tsdEntryData.length == 0) {
                            this.doInformationMessage("TSDQRYER", MsgType.ERROR_MESSAGE, false);
                        }
                        retainOk = false;
                        rsfEnabled = false;
                        phoneServer = false;
                        rsf = RsfManager.getRsfManager().getConsoleRsf();
                        if (rsf == null) {
                            h = new HException("console RSF unavailable");
                            TsdTasklet.logError("TsdTasklet: console RSF unavailable", h, (short)20585);
                            throw h;
                        }
                        rsfEnabled = rsf.isCallHomeEnabled();
                        phoneServer = rsf.isCallHomeServerAvailable();
                        if (!rsfEnabled || !phoneServer) break block25;
                        Trace.trace("XTSD   F", "Rsf and phone server available");
                        retainOk = true;
                        ** GOTO lbl55
                    }
                    Trace.trace("XTSD   F", "Rsf or phone server NOT available");
                    if (UserContext.getCurrentUserContext().isLocalContext()) break block21;
                    msgKey = "TSDDESNO";
                    if (TransmitSvcDataUtils.TKE || BaseRemoteSupportFacility.testFlag.equals("TEST_TKE")) {
                        msgKey = "TSK0001";
                    }
                    this.doInformationMessage(msgKey, MsgType.WARNING_MESSAGE, false);
                    Trace.trace("XTSD   T", "<-- initData()");
                    var8_11 = false;
                    var15_13 = null;
                    if (!busyDialogVisible) break block22;
                    try {
                        this.destroyBusyDialog();
                    }
                    catch (Exception e) {
                        Trace.trace("XTSD   F", "TsdTasklet: exception destroying busy dialog: " + e.getMessage());
                    }
                }
                return var8_11;
            }
            try {
                block23: {
                    if (!TransmitSvcDataUtils.TKE && !BaseRemoteSupportFacility.testFlag.equals("TEST_TKE")) {
                        if (rsfEnabled) {
                            this.doInformationMessage("TSDPHSRV", MsgType.WARNING_MESSAGE, false);
                        } else {
                            this.doInformationMessage("TSDRSFEN", MsgType.WARNING_MESSAGE, false);
                        }
                    }
lbl55:
                    // 5 sources

                    this.bean = new TransSrvDataBean();
                    lt = null;
                    control = null;
                    st = new String[this.tsdEntryData.length];
                    this.bean.setRsfEnabled(retainOk);
                    if (TransmitSvcDataUtils.SE || BaseRemoteSupportFacility.testFlag.equals("TEST_SE")) {
                        this.disketteItemChanged = true;
                        this.newDeviceIdentifier = 8;
                        this.newDeviceText = MediaServices.getMediaServices().getMediaDisplayableName(this.newDeviceIdentifier);
                        this.bean.setNewDisketteText(this.newDeviceText);
                        this.bean.setNoDvd(true);
                    }
                    args = new String[]{TransmitSvcDataUtils.SE != false ? new LocalizableText("com/ibm/hwmca/base/tsd/res/TransSrvDataStuffRes", "HTSI_SUB_SE").toString() : (TransmitSvcDataUtils.TKE != false || BaseRemoteSupportFacility.testFlag.equals("TEST_TKE") != false ? new LocalizableText("com/ibm/hwmca/base/tsd/res/TransSrvDataStuffRes", "HTSI_SUB_TKE").toString() : new LocalizableText("com/ibm/hwmca/base/tsd/res/TransSrvDataStuffRes", "HTSI_SUB_HMC").toString())};
                    for (i = 0; i < this.tsdEntryData.length; ++i) {
                        shortMsg = this.tsdEntryData[i].getMessageNumber();
                        msg = Short.toString(shortMsg);
                        Trace.trace("XTSD   F", "MSG STRING = " + msg);
                        lt = new LocalizableText("com/ibm/hwmca/base/tsd/res/TransSrvDataStuffRes", "HTSI_MSG_" + msg, args);
                        Trace.trace("XTSD   F", "MSG NAME = " + lt);
                        st[i] = lt.toString();
                        control = new TsdEnableControl(this.tsdEntryData[i].isFileAvailFlag(), this.tsdEntryData[i].isRetainFlag() != false && retainOk != false, this.tsdEntryData[i].isDisketteFlag(), this.tsdEntryData[i].isDvdFlag());
                        Trace.trace("XTSD   F", "Put elementName = SrvDataSel" + i + "Toggle");
                        this.bean.enableControl.put("SrvDataSel" + i + "Toggle", control);
                    }
                    this.bean.setNames(st);
                    if (!User.getUser().hasAuth("base.rolegroup.pedebug") && !User.getUser().hasAuth("base.rolegroup.service")) break block23;
                    this.bean.enablePeFiles(true);
                }
                var15_14 = null;
                ** if (!busyDialogVisible) goto lbl-1000
            }
            catch (Throwable var14_26) {
                var15_16 = null;
                if (busyDialogVisible) {
                    try {
                        this.destroyBusyDialog();
                    }
                    catch (Exception e) {
                        Trace.trace("XTSD   F", "TsdTasklet: exception destroying busy dialog: " + e.getMessage());
                    }
                }
                throw var14_26;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    this.destroyBusyDialog();
                }
                catch (Exception e) {
                    Trace.trace("XTSD   F", "TsdTasklet: exception destroying busy dialog: " + e.getMessage());
                }
            }
lbl-1000:
            // 2 sources

            {
                break block24;
                catch (Exception e) {
                    new FrameworkLog(TsdTasklet.logInfo, 20578, e).log();
                    result = false;
                    var15_15 = null;
                    if (busyDialogVisible) {
                        try {
                            this.destroyBusyDialog();
                        }
                        catch (Exception e) {
                            Trace.trace("XTSD   F", "TsdTasklet: exception destroying busy dialog: " + e.getMessage());
                        }
                    }
                }
            }
        }
        Trace.trace("XTSD   T", "<-- initData()");
        return result;
    }

    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> TsdTasklet.service(" + request + ", " + response + ")");
        boolean busyDialogVisible = false;
        try {
            if (request.isInitialRequest()) {
                if (!this.initData()) {
                    response.terminate();
                } else {
                    response.replace(AUIML, PANEL, this.bean);
                }
            } else if (request.isDisposed() || request.isCanceled()) {
                response.terminate();
            } else {
                String action = (String)request.getData("action");
                PanelBean bean = (PanelBean)request.getData("bean");
                Trace.trace(TRACE_MASKF, "action = " + action);
                if (action.equals("commit")) {
                    String[] selData = ((TransSrvDataBean)bean).getSrvDataSelGBSelection();
                    String peFileEdit = ((TransSrvDataBean)bean).getProdEngFilesEdit();
                    Trace.trace(TRACE_MASKF, "selData.length = " + selData.length + " peFileEdit length = " + peFileEdit.length() + " peFileEdit = " + peFileEdit);
                    boolean dontChange = false;
                    if (peFileEdit.length() > 0 && !TransmitSvcDataUtils.checkFilePattern(peFileEdit)) {
                        this.doInformationMessage("TSDNOPEF", MsgType.INFORMATION_MESSAGE, false);
                        dontChange = true;
                    } else {
                        TsdEntryData[] tsdSendData;
                        int numExtra = 0;
                        if (this.vretainList != null && this.vretainList.length > 0) {
                            ++numExtra;
                        }
                        if (this.iocdsList != null && this.iocdsList.length > 0) {
                            ++numExtra;
                        }
                        int baseEntries = selData.length;
                        if (peFileEdit.length() > 0) {
                            Trace.trace(TRACE_MASKF, "Create PE file entry");
                            ++baseEntries;
                            tsdSendData = new TsdEntryData[selData.length + 1 + numExtra];
                            tsdSendData[selData.length] = new TsdEntryData();
                            tsdSendData[selData.length].setDataType((byte)5);
                            tsdSendData[selData.length].setMessageNumber((short)27);
                            tsdSendData[selData.length].setProgramName("peData");
                            tsdSendData[selData.length].setPeFilePattern(peFileEdit);
                            tsdSendData[selData.length].setTsdUtilObject(utilClass);
                            int peIndex = peFileEdit.lastIndexOf("/");
                            String peFilename = peFileEdit.substring(peIndex + 1);
                            int strIndex = peFilename.lastIndexOf(".");
                            peIndex = peFilename.lastIndexOf(46);
                            if (peIndex == -1) {
                                peFilename = peFilename.concat(".zip");
                            } else {
                                peFilename = peFilename.substring(0, peIndex + 1);
                                peFilename = peFilename.concat("zip");
                            }
                            peFilename = peFilename.replace('*', '_');
                            peFilename = peFilename.replace('?', '_');
                            String zipFilepath = BaseFileControl.getFilePath(peFilename);
                            peFilename = zipFilepath.concat(peFilename);
                            Trace.trace(TRACE_MASKF, "Zip file name =" + peFilename);
                            tsdSendData[selData.length].setFileName(peFilename);
                        } else {
                            tsdSendData = new TsdEntryData[selData.length + numExtra];
                        }
                        boolean doingLogs = false;
                        String indexStr = null;
                        for (int i = 0; i < selData.length; ++i) {
                            indexStr = selData[i].substring(10, selData[i].indexOf("Toggle"));
                            int selIndex = Integer.valueOf(indexStr);
                            Trace.trace(TRACE_MASKF, "Selections = " + selData[i]);
                            Trace.trace(TRACE_MASKF, "Index = " + selIndex);
                            tsdSendData[i] = this.tsdEntryData[selIndex];
                            if (tsdSendData[i].getMessageNumber() != 18) continue;
                            doingLogs = true;
                        }
                        numExtra = 0;
                        if (this.vretainList != null && this.vretainList.length > 0) {
                            Trace.trace(TRACE_MASKT, "TsdTasklet.service() processing vretain files for commit.  Numextra=" + numExtra);
                            TsdEntryData entryData = new TsdEntryData();
                            entryData.setDataType((byte)5);
                            entryData.setMessageNumber((short)1);
                            entryData.setProgramName("vretainFiles");
                            entryData.setTsdUtilObject(utilClass);
                            entryData.setParmData(this.vretainList);
                            entryData.setFileName(this.vretainFilename);
                            tsdSendData[baseEntries + numExtra++] = entryData;
                        }
                        if (this.iocdsList != null && this.iocdsList.length > 0) {
                            Trace.trace(TRACE_MASKT, "TsdTasklet.service() processing iocds files for commit.  Numextra=" + numExtra);
                            TsdEntryData entryData = new TsdEntryData();
                            entryData.setDataType((byte)5);
                            entryData.setMessageNumber((short)1);
                            entryData.setProgramName("iocdsFiles");
                            entryData.setTsdUtilObject(utilClass);
                            entryData.setParmData(this.iocdsList);
                            entryData.setFileName(BaseFileControl.getFilePath(iocdsFilename) + iocdsFilename);
                            tsdSendData[baseEntries + numExtra++] = entryData;
                        }
                        Trace.trace(TRACE_MASKT, "TsdTasklet::service() number of entries=" + tsdSendData.length);
                        String pmh = new String(((TransSrvDataBean)bean).getPMHNumberEdit().toUpperCase());
                        Trace.trace(TRACE_MASKF, "PMH field = " + pmh);
                        String[] radioButton = new String[1];
                        radioButton = ((TransSrvDataBean)bean).getSrvDataDestChoiceSelection();
                        Trace.trace(TRACE_MASKF, "RadioButton = " + radioButton[0]);
                        if (radioButton[0].equals("IBMServiceItem")) {
                            Trace.trace(TRACE_MASKF, "Destination is RETAIN");
                            this.showBusyDialog(new LocalizableText(BaseTextBundle.getBundleName(), TSD_BUSY_TITLE), new LocalizableText(BaseTextBundle.getBundleName(), TSD_BUSY_SEND_TEXT));
                            busyDialogVisible = true;
                            try {
                                TsdSendData tsdSend = new TsdSendData();
                                tsdSend.send(tsdSendData, pmh);
                                busyDialogVisible = false;
                                this.doInformationMessage("TSDRSOK1", MsgType.INFORMATION_MESSAGE, busyDialogVisible);
                            }
                            catch (TsdRetrieveDataException e) {
                                TsdTasklet.logInfo("TsdTasklet:Retrieve data exception", e, (short)20585);
                                busyDialogVisible = false;
                                this.doInformationMessage("TSDERR02", MsgType.INFORMATION_MESSAGE, true);
                            }
                            catch (HException e) {
                                TsdTasklet.logError("TsdTasklet: Internal error exception", e, (short)20585);
                                busyDialogVisible = false;
                                this.doInformationMessage("TSDERR01", MsgType.INFORMATION_MESSAGE, true);
                            }
                        } else if (radioButton[0].equals("DisketteItem") && this.disketteItemChanged) {
                            Trace.trace(TRACE_MASKF, "Destination is " + this.newDeviceText);
                            Object[] args = new String[]{this.newDeviceText.toString()};
                            LocalizableText button = this.showMessageBox(true, new LocalizableText(BaseTextBundle.getBundleName(), TSD_TASK_TITLE), new BaseMessageText("TSDDEVIN", args), MsgType.INFORMATION_MESSAGE, new LocalizableText[]{CommonMsgInterface.OK_BUTTON, CommonMsgInterface.CANCEL_BUTTON});
                            if (button != null && button.equals(CommonMsgInterface.OK_BUTTON)) {
                                this.showBusyDialog(new LocalizableText(BaseTextBundle.getBundleName(), TSD_BUSY_TITLE), new LocalizableText(BaseTextBundle.getBundleName(), TSD_BUSY_COPY_TEXT));
                                busyDialogVisible = true;
                                try {
                                    TsdWriteDisk tsdWrite = new TsdWriteDisk();
                                    tsdWrite.write(this.newDeviceIdentifier, tsdSendData);
                                    busyDialogVisible = false;
                                    this.doInformationMessage("TSDDSKOK", MsgType.INFORMATION_MESSAGE, true);
                                }
                                catch (TsdMediaNotReadyException e) {
                                    TsdTasklet.logInfo("TsdTasklet:" + this.newDeviceText + " not ready exception", e, (short)20601);
                                    busyDialogVisible = false;
                                    this.doInformationMessage("TSDDEVRY", args, MsgType.INFORMATION_MESSAGE, true);
                                    dontChange = true;
                                }
                                catch (TsdMediaWriteProtectedException e) {
                                    TsdTasklet.logInfo("TsdTasklet: " + this.newDeviceText + " write protect exception", e, (short)20601);
                                    busyDialogVisible = false;
                                    this.doInformationMessage("TSDDSKPR", MsgType.INFORMATION_MESSAGE, true);
                                    dontChange = true;
                                }
                                catch (TsdRetrieveDataException e) {
                                    TsdTasklet.logInfo("TsdTasklet: Retrieve data exception", e, (short)20601);
                                    busyDialogVisible = false;
                                    this.doInformationMessage("TSDERR02", MsgType.INFORMATION_MESSAGE, true);
                                }
                                catch (TsdCopyDataException e) {
                                    TsdTasklet.logInfo("TsdTasklet: " + this.newDeviceText + " copy exception", e, (short)20601);
                                    busyDialogVisible = false;
                                    this.doInformationMessage("TSDERR03", MsgType.INFORMATION_MESSAGE, true);
                                    dontChange = true;
                                }
                                catch (TsdNoSpaceException e) {
                                    TsdTasklet.logInfo("TsdTasklet: Not enough space exception", e, (short)20601);
                                    busyDialogVisible = false;
                                    this.doInformationMessage("TSDSPACE", MsgType.INFORMATION_MESSAGE, true);
                                    dontChange = true;
                                }
                                catch (TsdMediaInUseException e) {
                                    TsdTasklet.logInfo("TsdTasklet: Media in use exception", e, (short)20601);
                                    busyDialogVisible = false;
                                    this.doInformationMessage("TSDDEVBY", args, MsgType.INFORMATION_MESSAGE, true);
                                    dontChange = true;
                                }
                                catch (TsdMediaLabelException e) {
                                    TsdTasklet.logInfo("TsdTasklet: Media label exception for " + this.newDeviceText + " should not happen", e, (short)20601);
                                    busyDialogVisible = false;
                                    this.doInformationMessage("TSDERR01", MsgType.INFORMATION_MESSAGE, true);
                                    dontChange = true;
                                }
                                catch (HException e) {
                                    TsdTasklet.logError("TsdTasklet: Internal error exception", e, (short)20601);
                                    busyDialogVisible = false;
                                    this.doInformationMessage("TSDERR01", MsgType.INFORMATION_MESSAGE, true);
                                }
                            } else {
                                dontChange = true;
                            }
                        } else if (radioButton[0].equals("DisketteItem")) {
                            Trace.trace(TRACE_MASKF, "Destination is DISKETTE");
                            LocalizableText button = this.showMessageBox(true, new LocalizableText(BaseTextBundle.getBundleName(), TSD_TASK_TITLE), new BaseMessageText("TSDDSKIN"), MsgType.INFORMATION_MESSAGE, new LocalizableText[]{CommonMsgInterface.OK_BUTTON, CommonMsgInterface.CANCEL_BUTTON});
                            if (button != null && button.equals(CommonMsgInterface.OK_BUTTON)) {
                                this.showBusyDialog(new LocalizableText(BaseTextBundle.getBundleName(), TSD_BUSY_TITLE), new LocalizableText(BaseTextBundle.getBundleName(), TSD_BUSY_COPY_TEXT));
                                busyDialogVisible = true;
                                try {
                                    TsdWriteDisk tsdWrite = new TsdWriteDisk();
                                    tsdWrite.write(1, tsdSendData);
                                    busyDialogVisible = false;
                                    this.doInformationMessage("TSDDSKOK", MsgType.INFORMATION_MESSAGE, true);
                                }
                                catch (TsdMediaNotReadyException e) {
                                    TsdTasklet.logInfo("TsdTasklet:Diskette not ready exception", e, (short)20583);
                                    busyDialogVisible = false;
                                    this.doInformationMessage("TSDDSKRY", MsgType.INFORMATION_MESSAGE, true);
                                    dontChange = true;
                                }
                                catch (TsdMediaWriteProtectedException e) {
                                    TsdTasklet.logInfo("TsdTasklet: Diskette write protect exception", e, (short)20583);
                                    busyDialogVisible = false;
                                    this.doInformationMessage("TSDDSKPR", MsgType.INFORMATION_MESSAGE, true);
                                    dontChange = true;
                                }
                                catch (TsdRetrieveDataException e) {
                                    TsdTasklet.logInfo("TsdTasklet: Retrieve data exception", e, (short)20583);
                                    busyDialogVisible = false;
                                    this.doInformationMessage("TSDERR02", MsgType.INFORMATION_MESSAGE, true);
                                }
                                catch (TsdCopyDataException e) {
                                    TsdTasklet.logInfo("TsdTasklet: Diskette copy exception", e, (short)20583);
                                    busyDialogVisible = false;
                                    this.doInformationMessage("TSDERR03", MsgType.INFORMATION_MESSAGE, true);
                                    dontChange = true;
                                }
                                catch (TsdNoSpaceException e) {
                                    TsdTasklet.logInfo("TsdTasklet: Not enough space exception", e, (short)20583);
                                    busyDialogVisible = false;
                                    this.doInformationMessage("TSDSPACE", MsgType.INFORMATION_MESSAGE, true);
                                    if (doingLogs) {
                                        this.doInformationMessage("TSDDSKLG", MsgType.INFORMATION_MESSAGE, false);
                                    }
                                    dontChange = true;
                                }
                                catch (TsdMediaInUseException e) {
                                    TsdTasklet.logInfo("TsdTasklet: Media in use exception", e, (short)20583);
                                    busyDialogVisible = false;
                                    this.doInformationMessage("TSDDSKBY", MsgType.INFORMATION_MESSAGE, true);
                                    dontChange = true;
                                }
                                catch (TsdMediaLabelException e) {
                                    TsdTasklet.logInfo("TsdTasklet: Media label exception", e, (short)20583);
                                    busyDialogVisible = false;
                                    this.doInformationMessage("TSDDSKLB", MsgType.INFORMATION_MESSAGE, true);
                                    dontChange = true;
                                }
                                catch (HException e) {
                                    TsdTasklet.logError("TsdTasklet: Internal error exception", e, (short)20583);
                                    busyDialogVisible = false;
                                    this.doInformationMessage("TSDERR01", MsgType.INFORMATION_MESSAGE, true);
                                }
                            } else {
                                dontChange = true;
                            }
                        } else {
                            Trace.trace(TRACE_MASKF, "Destination is DVD");
                            LocalizableText button = this.showMessageBox(true, new LocalizableText(BaseTextBundle.getBundleName(), TSD_TASK_TITLE), new BaseMessageText("TSDDVDIN"), MsgType.INFORMATION_MESSAGE, new LocalizableText[]{CommonMsgInterface.OK_BUTTON, CommonMsgInterface.CANCEL_BUTTON});
                            if (button != null && button.equals(CommonMsgInterface.OK_BUTTON)) {
                                this.showBusyDialog(new LocalizableText(BaseTextBundle.getBundleName(), TSD_BUSY_TITLE), new LocalizableText(BaseTextBundle.getBundleName(), TSD_BUSY_COPY_TEXT));
                                busyDialogVisible = true;
                                try {
                                    TsdWriteDisk tsdWrite = new TsdWriteDisk();
                                    tsdWrite.write(3, tsdSendData);
                                    busyDialogVisible = false;
                                    this.doInformationMessage("TSDDSKOK", MsgType.INFORMATION_MESSAGE, true);
                                }
                                catch (TsdMediaNotReadyException e) {
                                    TsdTasklet.logInfo("TsdTasklet: Dvd not ready exception", e, (short)20584);
                                    busyDialogVisible = false;
                                    this.doInformationMessage("TSDDVDRY", MsgType.INFORMATION_MESSAGE, true);
                                    dontChange = true;
                                }
                                catch (TsdMediaWriteProtectedException e) {
                                    TsdTasklet.logInfo("TsdTasklet: Dvd write protect exception", e, (short)20584);
                                    busyDialogVisible = false;
                                    this.doInformationMessage("TSDDVDPR", MsgType.INFORMATION_MESSAGE, true);
                                    dontChange = true;
                                }
                                catch (TsdRetrieveDataException e) {
                                    TsdTasklet.logInfo("TsdTasklet: Retrieve data exception", e, (short)20584);
                                    busyDialogVisible = false;
                                    this.doInformationMessage("TSDERR02", MsgType.INFORMATION_MESSAGE, true);
                                }
                                catch (TsdCopyDataException e) {
                                    TsdTasklet.logInfo("TsdTasklet: Dvd copy exception", e, (short)20584);
                                    busyDialogVisible = false;
                                    this.doInformationMessage("TSDERR03", MsgType.INFORMATION_MESSAGE, true);
                                    dontChange = true;
                                }
                                catch (TsdNoSpaceException e) {
                                    TsdTasklet.logInfo("TsdTasklet: Not enough space exception", e, (short)20584);
                                    busyDialogVisible = false;
                                    this.doInformationMessage("TSDSPACE", MsgType.INFORMATION_MESSAGE, true);
                                    dontChange = true;
                                }
                                catch (TsdMediaInUseException e) {
                                    TsdTasklet.logInfo("TsdTasklet: Media in use exception", e, (short)20584);
                                    busyDialogVisible = false;
                                    this.doInformationMessage("TSDINUSE", MsgType.INFORMATION_MESSAGE, true);
                                    dontChange = true;
                                }
                                catch (TsdMediaLabelException e) {
                                    TsdTasklet.logInfo("TsdTasklet: Media label exception", e, (short)20584);
                                    busyDialogVisible = false;
                                    this.doInformationMessage("TSDLABEL", MsgType.INFORMATION_MESSAGE, true);
                                    dontChange = true;
                                }
                                catch (HException e) {
                                    TsdTasklet.logError("TsdTasklet: Internal error exception", e, (short)20584);
                                    busyDialogVisible = false;
                                    this.doInformationMessage("TSDERR01", MsgType.INFORMATION_MESSAGE, true);
                                }
                            } else {
                                dontChange = true;
                            }
                        }
                    }
                    if (!dontChange) {
                        response.terminate();
                    } else {
                        response.noAction();
                    }
                } else if (action.equals("vretain")) {
                    int vRetNum = (int)((TransSrvDataBean)bean).getVRetainNumber();
                    TransVRetainBean childBean = new TransVRetainBean((TransSrvDataBean)bean);
                    childBean.setFileList(this.getVRetainFiles(vRetNum));
                    response.openModalChild(AUIML, VRETAIN_PANEL, childBean);
                } else if (action.equals("iocds")) {
                    TransIOCDSFilesBean childBean = new TransIOCDSFilesBean((TransSrvDataBean)bean);
                    childBean.setFileList(this.getIOCDSFiles());
                    response.openModalChild(AUIML, IOCDS_PANEL, childBean);
                } else if (action.equals("cancel")) {
                    response.dispose();
                } else if (action.equals("saveV")) {
                    this.vretainList = ((TransVRetainBean)bean).getSelectedFiles();
                    for (int i = 0; i < this.vretainList.length; ++i) {
                        this.vretainList[i] = this.vretainFilePath + this.vretainList[i];
                    }
                    Trace.trace(TRACE_MASKF, "TsdTasklet: v retain files=" + TsdTasklet.arrayToString(this.vretainList));
                    response.dispose();
                } else if (action.equals("saveI")) {
                    this.iocdsList = ((TransIOCDSFilesBean)bean).getSelectedFiles();
                    String iocdsFilePath = BaseFileControl.getFilePath(IOCDS_FILE_PATTERN);
                    for (int i = 0; i < this.iocdsList.length; ++i) {
                        this.iocdsList[i] = iocdsFilePath + this.iocdsList[i];
                    }
                    Trace.trace(TRACE_MASKF, "TsdTasklet: v retain files=" + TsdTasklet.arrayToString(this.vretainList));
                    response.dispose();
                } else {
                    response.noAction();
                }
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "TsdTasklet: exception caught");
            Trace.trace(TRACE_MASKF, e);
            TaskletException texc = new TaskletException(e);
            new FrameworkLog(logInfo, 20579, texc).log();
            throw texc;
        }
        finally {
            if (busyDialogVisible) {
                this.destroyBusyDialog();
            }
        }
        Trace.trace(TRACE_MASKT, "<-- service()");
    }

    private static String arrayToString(Object[] o) {
        if (o == null) {
            return "null";
        }
        if (o.length == 0) {
            return "empty";
        }
        StringBuffer buffer = new StringBuffer(" " + o[0]);
        for (int i = 1; i < o.length; ++i) {
            buffer.append("," + o[i]);
        }
        return buffer.toString();
    }

    private String[] getIOCDSFiles() {
        try {
            File[] list = TransmitSvcDataUtils.getFilesList(IOCDS_FILE_PATTERN, IOCDS_FILE_LOCATION_PATTERN);
            String[] filenames = new String[list.length];
            StringBuffer buffer = new StringBuffer("");
            for (int i = 0; i < list.length; ++i) {
                filenames[i] = list[i].getName();
                buffer.append(" " + i + " " + filenames[i]);
            }
            Trace.trace(TRACE_MASKF, "TsdTasklet: iocds files (" + list.length + ")= " + buffer.toString());
            return filenames;
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "TsdTasklet: error getting IOCDS files");
            return new String[0];
        }
    }

    private String[] getVRetainFiles(int vRetNum) {
        try {
            String path = BaseFileControl.getFilePath(VIRTUAL_RETAIN_DIR);
            this.vretainFilePath = path + vRetNum + File.separator;
            this.vretainFilename = "iqysv" + vRetNum + ".zip";
            this.vretainFilename = BaseFileControl.getFilePath(this.vretainFilename) + this.vretainFilename;
            File vretFile = new File(path + vRetNum);
            Trace.trace(TRACE_MASKF, "TsdTasklet: getting vretain files in " + vretFile);
            File[] list = vretFile.listFiles();
            String[] filenames = new String[list.length];
            for (int i = 0; i < list.length; ++i) {
                filenames[i] = list[i].getName();
            }
            return filenames;
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "TsdTasklet: can't find vretain file path");
            return new String[0];
        }
    }

    public void doInformationMessage(String msg, MsgType messageType, boolean destroyBusy) {
        this.doInformationMessage(msg, null, messageType, destroyBusy);
    }

    public void doInformationMessage(String msg, Object[] args, MsgType messageType, boolean destroyBusy) {
        try {
            if (destroyBusy) {
                this.destroyBusyDialog();
            }
            BaseMessageText msgText = args == null ? new BaseMessageText(msg) : new BaseMessageText(msg, args);
            this.showMessageBox(true, new LocalizableText(BaseTextBundle.getBundleName(), TSD_TASK_TITLE), msgText, messageType, new LocalizableText[]{CommonMsgInterface.OK_BUTTON});
        }
        catch (Exception e) {
            TsdTasklet.logInfo("TsdTasklet: exception showing message or deleting busy", e, (short)20580);
        }
    }

    public void doInformationMessageAndLog(String infoMsg, MsgType msgType, boolean destroyBusy, String logMsg, Throwable t, short errorId, boolean errorLog) {
        this.doInformationMessage(infoMsg, msgType, destroyBusy);
        if (errorLog) {
            TsdTasklet.logError(logMsg, t, errorId);
        } else {
            TsdTasklet.logInfo(logMsg, t, errorId);
        }
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "--> logException(" + throwable + ")");
        Trace.trace(TRACE_MASKT, throwable);
        new FrameworkLog(logInfo, 20580, throwable).log();
        Trace.trace(TRACE_MASKT, "<-- logException()");
    }

    private static void logInfo(String msg, Throwable t, short errorId) {
        Trace.trace(TRACE_MASKF, msg);
        if (t != null) {
            Trace.trace(TRACE_MASKF, t);
        }
        FrameworkLog errLog = t != null ? new FrameworkLog(logInfo, errorId, t) : new FrameworkLog(logInfo, errorId);
        errLog.add(msg);
        errLog.log(infoLog);
    }

    private static void logError(String msg, Throwable t, short errorId) {
        Trace.trace(TRACE_MASKF, msg);
        if (t != null) {
            Trace.trace(TRACE_MASKF, t);
        }
        FrameworkLog errLog = t != null ? new FrameworkLog(logInfo, errorId, t) : new FrameworkLog(logInfo, errorId);
        errLog.add(msg);
        errLog.log();
    }
}

